/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.core.Options;
import org.python.core.packagecache.PackageManager;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedJarsPackageManager
extends PackageManager {
    private boolean indexModified;
    private Map<String, JarXEntry> jarfiles;
    private File cachedir;

    protected void message(String string) {
    }

    protected void warning(String string) {
    }

    protected void comment(String string) {
    }

    protected void debug(String string) {
    }

    protected boolean filterByName(String string, boolean bl) {
        return string.indexOf(36) != -1;
    }

    protected boolean filterByAccess(String string, int n) {
        return (n & 1) != 1;
    }

    private static String listToString(List<String> list) {
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(list.get(i));
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private void addZipEntry(Map<String, List<String>[]> map, ZipEntry zipEntry, ZipInputStream zipInputStream) throws IOException {
        int n;
        String string = zipEntry.getName();
        if (!string.endsWith(".class")) {
            return;
        }
        char c = '/';
        int n2 = string.lastIndexOf(c);
        if (n2 == -1) {
            n2 = string.lastIndexOf(92);
            c = '\\';
        }
        String string2 = n2 == -1 ? "" : string.substring(0, n2).replace(c, '.');
        String string3 = string.substring(n2 + 1, string.length() - 6);
        if (this.filterByName(string3, false)) {
            return;
        }
        List<String>[] listArray = map.get(string2);
        if (listArray == null) {
            listArray = this.createGenericStringListArray();
            map.put(string2, listArray);
        }
        if ((n = CachedJarsPackageManager.checkAccess(zipInputStream)) != -1 && !this.filterByAccess(string, n)) {
            listArray[0].add(string3);
        } else {
            listArray[1].add(string3);
        }
    }

    private List<String>[] createGenericStringListArray() {
        return new List[]{Generic.list(), Generic.list()};
    }

    private Map<String, String> getZipPackages(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        Map<String, List<String>[]> map = Generic.map();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.addZipEntry(map, zipEntry, zipInputStream);
            zipInputStream.closeEntry();
        }
        Map<String, String> map2 = Generic.map();
        for (Map.Entry entry : map.entrySet()) {
            List[] listArray = (List[])entry.getValue();
            String string = CachedJarsPackageManager.listToString(listArray[0]);
            if (listArray[1].size() > 0) {
                string = string + '@' + CachedJarsPackageManager.listToString(listArray[1]);
            }
            map2.put((String)entry.getKey(), string);
        }
        return map2;
    }

    public void addJarToPackages(URL uRL) {
        this.addJarToPackages(uRL, null, false);
    }

    public void addJarToPackages(URL uRL, boolean bl) {
        this.addJarToPackages(uRL, null, bl);
    }

    public void addJarToPackages(File file) {
        this.addJarToPackages(null, file, false);
    }

    public void addJarToPackages(File file, boolean bl) {
        this.addJarToPackages(null, file, bl);
    }

    private void addJarToPackages(URL uRL, File file, boolean bl) {
        try {
            Object object;
            Map<String, String> map;
            boolean bl2 = this.jarfiles != null;
            URLConnection uRLConnection = null;
            boolean bl3 = true;
            if (file == null) {
                uRLConnection = uRL.openConnection();
                if (uRLConnection.getURL().getProtocol().equals("file")) {
                    map = uRL.getFile();
                    map = ((String)((Object)map)).replace('/', File.separatorChar);
                    file = new File((String)((Object)map));
                } else {
                    bl3 = false;
                }
            }
            if (bl3 && !file.exists()) {
                return;
            }
            map = null;
            long l = 0L;
            String string = null;
            JarXEntry jarXEntry = null;
            boolean bl4 = false;
            if (bl2) {
                if (bl3) {
                    l = file.lastModified();
                    string = file.getCanonicalPath();
                } else {
                    l = uRLConnection.getLastModified();
                    string = uRL.toString();
                }
                jarXEntry = this.jarfiles.get(string);
                if ((jarXEntry == null || !new File(jarXEntry.cachefile).exists()) && bl) {
                    this.message("processing new jar, '" + string + "'");
                    if (bl3) {
                        object = file.getName();
                    } else {
                        object = uRL.getFile();
                        int n = ((String)object).lastIndexOf(47);
                        if (n != -1) {
                            object = ((String)object).substring(n + 1);
                        }
                    }
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                    jarXEntry = new JarXEntry((String)object);
                    this.jarfiles.put(string, jarXEntry);
                    bl4 = true;
                }
                if (l != 0L && jarXEntry != null && jarXEntry.mtime == l) {
                    map = this.readCacheFile(jarXEntry, string);
                }
            }
            if (map == null) {
                boolean bl5 = bl2 = bl2 && bl;
                if (bl2) {
                    this.indexModified = true;
                    if (jarXEntry.mtime != 0L) {
                        this.message("processing modified jar, '" + string + "'");
                    }
                    jarXEntry.mtime = l;
                }
                object = uRLConnection == null ? new BufferedInputStream(new FileInputStream(file)) : uRLConnection.getInputStream();
                map = this.getZipPackages((InputStream)object);
                if (bl2) {
                    this.writeCacheFile(jarXEntry, string, map, bl4);
                }
            }
            this.addPackages(map, string);
        }
        catch (IOException iOException) {
            this.warning("skipping bad jar, '" + (file != null ? file.toString() : uRL.toString()) + "'");
        }
    }

    private void addPackages(Map<String, String> map, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            int n = string3.indexOf(64);
            if (n >= 0 && Options.respectJavaAccessibility) {
                string3 = string3.substring(0, n);
            }
            this.makeJavaPackage(string2, string3, string);
        }
    }

    private Map<String, String> readCacheFile(JarXEntry jarXEntry, String string) {
        String string2 = jarXEntry.cachefile;
        long l = jarXEntry.mtime;
        this.debug("reading cache, '" + string + "'");
        try {
            DataInputStream dataInputStream = this.inOpenCacheFile(string2);
            String string3 = dataInputStream.readUTF();
            long l2 = dataInputStream.readLong();
            if (!string3.equals(string) || l2 != l) {
                this.comment("invalid cache file: " + string2 + ", " + string + ":" + string3 + ", " + l + ":" + l2);
                this.deleteCacheFile(string2);
                return null;
            }
            Map<String, String> map = Generic.map();
            try {
                while (true) {
                    String string4 = dataInputStream.readUTF();
                    String string5 = dataInputStream.readUTF();
                    if (map.containsKey(string4)) {
                        string5 = map.get(string4) + string5;
                    }
                    map.put(string4, string5);
                }
            }
            catch (EOFException eOFException) {
                dataInputStream.close();
                return map;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void writeCacheFile(JarXEntry jarXEntry, String string, Map<String, String> map, boolean bl) {
        try {
            DataOutputStream dataOutputStream = this.outCreateCacheFile(jarXEntry, bl);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeLong(jarXEntry.mtime);
            this.comment("rewriting cachefile for '" + string + "'");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string2 = entry.getValue();
                for (String string3 : CachedJarsPackageManager.splitString(string2, 65535)) {
                    dataOutputStream.writeUTF(entry.getKey());
                    dataOutputStream.writeUTF(string3);
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write cache file for '" + string + "'");
        }
    }

    protected static String[] splitString(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 <= n) {
            return new String[]{string};
        }
        int n3 = (int)Math.ceil((float)n2 / (float)n);
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = string.substring(i * n, Math.min(i * n + n, n2));
        }
        return stringArray;
    }

    protected void initCache() {
        this.indexModified = false;
        this.jarfiles = Generic.map();
        try {
            DataInputStream dataInputStream = this.inOpenIndex();
            if (dataInputStream == null) {
                return;
            }
            try {
                while (true) {
                    String string = dataInputStream.readUTF();
                    String string2 = dataInputStream.readUTF();
                    long l = dataInputStream.readLong();
                    this.jarfiles.put(string, new JarXEntry(string2, l));
                }
            }
            catch (EOFException eOFException) {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            this.warning("invalid index file");
        }
    }

    public void saveCache() {
        if (this.jarfiles == null || !this.indexModified) {
            return;
        }
        this.indexModified = false;
        this.comment("writing modified index file");
        try {
            DataOutputStream dataOutputStream = this.outOpenIndex();
            for (Map.Entry<String, JarXEntry> entry : this.jarfiles.entrySet()) {
                String string = entry.getKey();
                JarXEntry jarXEntry = entry.getValue();
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF(jarXEntry.cachefile);
                dataOutputStream.writeLong(jarXEntry.mtime);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write index file");
        }
    }

    protected DataInputStream inOpenIndex() throws IOException {
        File file = new File(this.cachedir, "packages.idx");
        if (!file.exists()) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        return dataInputStream;
    }

    protected DataOutputStream outOpenIndex() throws IOException {
        File file = new File(this.cachedir, "packages.idx");
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    protected DataInputStream inOpenCacheFile(String string) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
    }

    protected void deleteCacheFile(String string) {
        new File(string).delete();
    }

    protected DataOutputStream outCreateCacheFile(JarXEntry jarXEntry, boolean bl) throws IOException {
        File file = null;
        if (bl) {
            int n = 1;
            String string = "";
            String string2 = jarXEntry.cachefile;
            while ((file = new File(this.cachedir, string2 + string + ".pkc")).exists()) {
                string = "$" + n;
                ++n;
            }
            jarXEntry.cachefile = file.getCanonicalPath();
        } else {
            file = new File(jarXEntry.cachefile);
        }
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    protected boolean useCacheDir(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (!file.isDirectory() && !file.mkdirs()) {
                this.warning("can't create package cache dir, '" + file + "'");
                return false;
            }
        }
        catch (AccessControlException accessControlException) {
            this.warning("The java security manager isn't allowing access to the package cache dir, '" + file + "'");
            return false;
        }
        this.cachedir = file;
        return true;
    }

    public static class JarXEntry {
        public String cachefile;
        public long mtime;

        public JarXEntry(String string) {
            this.cachefile = string;
        }

        public JarXEntry(String string, long l) {
            this.cachefile = string;
            this.mtime = l;
        }
    }
}

